*CONSUMER UTILITY MAXIMIZATION --------------------------------
*DECLARATION --------------------------------------------------

*Indices
SETS C commodities
 /
  AGR-C
  NAGR-C
 /;

ALIAS (C,CP);

*Exogenous 'variables'
PARAMETERS
 p(C)            price of commodity C
 beta(C)         household expenditure share for commodity C
 y               household income
;

*Endogenous variables
VARIABLES
 Q(C)            household consumption of commodity C
 U               total utility (objective variable)
;

*Model Equations
EQUATIONS
 UTILITY         objective function
 BUDCONS         budget constraint
;

UTILITY..        U =E= PROD(C, Q(C)**beta(C));
BUDCONS..        y =E= SUM(C, p(C)*Q(C));

MODEL UTILMAX /ALL/;

*CALIBRATION OR DEFINITION ------------------------------------

*Read in initial consumption data
PARAMETER
 consval(C)      initial consumption levels
  /AGR-C 125, NAGR-C 150/
;

*Base year values of key parameters and variables (storage)
PARAMETERS
 p0(C)           base price of commodity C
 y0              base household income
 Q0(C)           base household consumption of commodity C
;

p0(C)    = 1;
Q0(C)    = consval(C)/p0(C);
y0       = sum(C, consval(C));

*Initialize model parameters and variables
beta(C)  = consval(C)/SUM(CP, consval(CP));
p(C)     = p0(C);
y        = y0;
Q.L(C)   = Q0(C);

DISPLAY P, Y, BETA, Q.L;

*Solve model and report results ------------------------------

SET SIM /
 BASE
 SIM1
 SIM2
/;

PARAMETER
 QTAB(C,SIM)
 PTAB(C,SIM)
 CVALTAB(C,SIM)
 UTAB(SIM)
;

*Solve model with initial values
SOLVE UTILMAX MAXIMIZING U USING NLP;
*Save results
QTAB(C,'BASE')    = Q.L(C);
PTAB(C,'BASE')    = p(C);
CVALTAB(C,'BASE') = p(C)*Q.L(C);
UTAB('BASE')      = U.L;

*Change price of commodities  in Sim1
p('AGR-C')  = p0('AGR-C')  * 1.0;
p('NAGR-C') = p0('NAGR-C') * 1.1;
*Solve model with initial values
SOLVE UTILMAX MAXIMIZING U USING NLP;
*Save results
QTAB(C,'SIM1')    = Q.L(C);
PTAB(C,'SIM1')    = p(C);
CVALTAB(C,'SIM1') = p(C)*Q.L(C);
UTAB('SIM1')      = U.L;

*Change price of commodities  in Sim2
p('AGR-C')  = p0('AGR-C')  * 1.1;
p('NAGR-C') = p0('NAGR-C') * 1.0;
*Solve model with initial values
SOLVE UTILMAX MAXIMIZING U USING NLP;
*Save results
QTAB(C,'SIM2')    = Q.L(C);
PTAB(C,'SIM2')    = p(C);
CVALTAB(C,'SIM2') = p(C)*Q.L(C);
UTAB('SIM2')      = U.L;

DISPLAY PTAB, QTAB, CVALTAB, UTAB;


